/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.entity.custom;

import com.zainjx.the_wild_update.entity.custom.FrogEntity;
import com.zainjx.the_wild_update.entity.custom.Vibration;
import com.zainjx.the_wild_update.gui.container.ChestBoatContainer;
import com.zainjx.the_wild_update.registry.RegistryItems;
import com.zainjx.the_wild_update.registry.RegistryMangrove;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class ChestBoat
extends Boat
implements Container,
MenuProvider,
ICapabilityProvider {
    private static final EntityDataAccessor<String> WOOD_TYPE = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)38, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> inventory;
    private final SimpleContainer theInventory = new SimpleContainer(9);
    ChestBoat thiss;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    SimpleContainer tempInv = new SimpleContainer(this.itemHandler.getSlots());
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(ChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(27){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ChestBoat.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public ChestBoat(EntityType<? extends ChestBoat> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
        this.thiss = this;
    }

    public ChestBoat(Level worldIn, double x, double y, double z, EntityType<? extends ChestBoat> boatToSpawn) {
        this(boatToSpawn, worldIn);
        this.thiss = this;
        this.inventory = NonNullList.m_122780_((int)40, (Object)ItemStack.f_41583_);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19790_ = x;
        this.f_19791_ = y;
        this.f_19792_ = z;
    }

    public String getWoodType() {
        return (String)this.f_19804_.m_135370_(WOOD_TYPE);
    }

    public void setWoodType(String wood) {
        this.f_19804_.m_135381_(WOOD_TYPE, (Object)wood);
    }

    public Item m_38369_() {
        switch (this.getWoodType()) {
            case "acacia": {
                return (Item)RegistryItems.ACACIA_CHEST_BOAT.get();
            }
            case "birch": {
                return (Item)RegistryItems.BIRCH_CHEST_BOAT.get();
            }
            case "dark_oak": {
                return (Item)RegistryItems.DARK_OAK_CHEST_BOAT.get();
            }
            case "jungle": {
                return (Item)RegistryItems.JUNGLE_CHEST_BOAT.get();
            }
            case "oak": {
                return (Item)RegistryItems.OAK_CHEST_BOAT.get();
            }
            case "spruce": {
                return (Item)RegistryItems.SPRUCE_CHEST_BOAT.get();
            }
        }
        return (Item)RegistryItems.MANGROVE_CHEST_BOAT.get();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_wild_update", this.getWoodType() + "_boat")));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WOOD_TYPE, (Object)"mangrove");
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
    }

    public InteractionResult m_6096_(Player sourceentity, InteractionHand hand) {
        super.m_6096_(sourceentity, hand);
        if (sourceentity.m_36341_() && !this.f_19853_.m_5776_()) {
            ServerPlayer _ent = (ServerPlayer)sourceentity;
            BlockPos _bpos = sourceentity.m_20097_();
            NetworkHooks.openGui((ServerPlayer)_ent, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("screen.the_wild_update.chest_boat");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    return new ChestBoatContainer(id, player.f_19853_, inventory, player, (IItemHandler)ChestBoat.this.itemHandler);
                }
            }, (BlockPos)_bpos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tempInv = new SimpleContainer(this.itemHandler.getSlots());
        this.tempInv.m_6596_();
        if (this.m_20197_().size() == 0) {
            new Vibration(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_()).m_20329_((Entity)this);
        }
    }

    public void m_7332_(Entity p_38379_) {
        if (this.m_20363_(p_38379_)) {
            float f = 0.3f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + p_38379_.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(p_38379_);
                f = i == 0 ? 0.2f : -0.6f;
                if (p_38379_ instanceof Animal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            p_38379_.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            this.m_38321_(p_38379_);
            if (p_38379_ instanceof Animal && this.m_20197_().size() > 1) {
                int j = p_38379_.m_142049_() % 2 == 0 ? 90 : 270;
                p_38379_.m_5618_(((Animal)p_38379_).f_20883_ + (float)j);
                p_38379_.m_5616_(p_38379_.m_6080_() + (float)j);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player p_39956_) {
        return new ChestBoatContainer(id, FrogEntity.player.f_19853_, inventory, FrogEntity.player, (IItemHandler)this.itemHandler);
    }

    public int m_6643_() {
        return 27;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.itemStacks.add((Object)this.itemHandler.getStackInSlot(slot));
        return ContainerHelper.m_18969_(this.itemStacks, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int p_150257_) {
        return p_150257_ >= 0 && p_150257_ < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return ChestBoat.this.m_8020_(p_150257_);
            }

            public boolean m_142104_(ItemStack p_150265_) {
                ChestBoat.this.m_6836_(p_150257_, p_150265_);
                return true;
            }
        } : super.m_141942_(p_150257_);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player p_18946_) {
        if (this.m_146910_()) {
            return false;
        }
        return !(p_18946_.m_20280_((Entity)this) > 64.0);
    }

    public void m_6211_() {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7380_(CompoundTag p_30496_) {
        super.m_7380_(p_30496_);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        p_30496_.m_128365_("Items", (Tag)listtag);
    }

    public void m_7378_(CompoundTag p_30488_) {
        super.m_7378_(p_30488_);
        ListTag listtag = p_30488_.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= this.itemHandler.getSlots()) continue;
            this.itemHandler.setStackInSlot(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    public void setType(Type p_38333_) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)p_38333_.ordinal());
    }

    public Type getBoatTypeMy() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    public static enum Type {
        OAK(Blocks.f_50705_, "oak"),
        MANGROVE((Block)RegistryMangrove.MANGROVE_PLANKS.get(), "planks"),
        SPRUCE(Blocks.f_50741_, "spruce"),
        BIRCH(Blocks.f_50742_, "birch"),
        JUNGLE(Blocks.f_50743_, "jungle"),
        ACACIA(Blocks.f_50744_, "acacia"),
        DARK_OAK(Blocks.f_50745_, "dark_oak");

        private final String name;
        private final Block planks;

        private Type(Block p_38427_, String p_38428_) {
            this.name = p_38428_;
            this.planks = p_38427_;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int p_38431_) {
            Type[] aboat$type = Type.values();
            if (p_38431_ < 0 || p_38431_ >= aboat$type.length) {
                p_38431_ = 0;
            }
            return aboat$type[p_38431_];
        }

        public static Type byName(String p_38433_) {
            Type[] aboat$type = Type.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].getName().equals(p_38433_)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }
}

